/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonTrajectoryRenderer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlywheelCompat;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CannonBlockTileRenderer
implements BlockEntityRenderer<CannonBlockTile> {
    private final ModelPart head;
    private final ModelPart legs;
    private final ModelPart pivot;
    private final ModelPart model;

    public CannonBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart model = context.m_173582_(ClientRegistry.CANNON_MODEL);
        this.legs = model.m_171324_("legs");
        this.pivot = this.legs.m_171324_("head_pivot");
        this.head = this.pivot.m_171324_("head");
        this.model = model;
    }

    public boolean shouldRenderOffScreen(CannonBlockTile blockEntity) {
        return true;
    }

    public void render(CannonBlockTile tile, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float scale;
        CannonTrajectoryRenderer.render(tile, poseStack, bufferSource, packedLight, packedOverlay, partialTick);
        if (CompatHandler.FLYWHEEL && FlywheelCompat.isOn()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        Quaternionf rotation = ((Direction)tile.m_58900_().m_61143_((Property)CannonBlock.f_52588_)).m_122424_().m_253075_();
        poseStack.m_252781_(rotation);
        VertexConsumer builder = ModMaterials.CANNON_MATERIAL.m_119194_(bufferSource, RenderType::m_110452_);
        float pitchRad = tile.getPitch(partialTick) * ((float)Math.PI / 180);
        float yawRad = tile.getYaw(partialTick) * ((float)Math.PI / 180);
        Vector3f forward = new Vector3f(0.0f, 0.0f, 1.0f);
        forward.rotateX((float)Math.PI - pitchRad);
        forward.rotateY((float)Math.PI - yawRad);
        forward.rotate((Quaternionfc)rotation.invert());
        yawRad = (float)Mth.m_14136_((double)forward.x, (double)forward.z);
        pitchRad = (float)Mth.m_14136_((double)(-forward.y), (double)Mth.m_14116_((float)(forward.x * forward.x + forward.z * forward.z)));
        this.legs.f_104204_ = yawRad;
        this.pivot.f_104203_ = pitchRad;
        this.pivot.f_104205_ = 0.0f;
        float cooldownCounter = tile.getCooldownAnimation(partialTick);
        float fireCounter = tile.getFiringAnimation(partialTick);
        float squish = CannonBlockTileRenderer.triangle(1.0f - cooldownCounter, 0.01f, 0.15f) * 0.2f;
        float wobble = Mth.m_14031_((float)(fireCounter * 20.0f * (float)Math.PI)) * 0.005f;
        this.head.f_233553_ = scale = wobble + 1.0f + squish * 0.7f;
        this.head.f_233554_ = scale;
        this.head.f_233555_ = 1.0f - squish;
        this.head.f_104202_ = squish * 5.675f;
        this.model.m_104301_(poseStack, builder, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    public static float triangle(float cooldownCounter, float mid, float end) {
        if (cooldownCounter <= mid) {
            float slope = 1.0f / mid;
            return slope * cooldownCounter;
        }
        if (cooldownCounter <= end) {
            float slope = -1.0f / (end - mid);
            return slope * (cooldownCounter - mid) + 1.0f;
        }
        return 0.0f;
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition legs = partdefinition.m_171599_("legs", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(6.0f, -4.0f, -3.0f, 2.0f, 10.0f, 6.0f).m_171514_(48, 0).m_171481_(-8.0f, -4.0f, -3.0f, 2.0f, 10.0f, 6.0f), PartPose.f_171404_);
        PartDefinition head = legs.m_171599_("head_pivot", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bone = head.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171481_(-6.0f, -6.0f, -6.5f, 12.0f, 12.0f, 6.0f).m_171514_(0, 18).m_171488_(-6.0f, -6.0f, -6.5f, 12.0f, 12.0f, 13.0f, new CubeDeformation(-0.3125f)), PartPose.f_171404_);
        PartDefinition base = partdefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, 6.0f, -8.0f, 16.0f, 2.0f, 16.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

